/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.util.FramedBlockData;
import xfacthd.framedblocks.api.util.client.ModelUtils;
import xfacthd.framedblocks.common.blockentity.FramedDoubleBlockEntity;

public abstract class FramedDoubleBlockModel
extends BakedModelProxy {
    private final boolean specialItemModel;
    private Tuple<BlockState, BlockState> dummyStates = null;
    private Tuple<BakedModel, BakedModel> models = null;

    protected FramedDoubleBlockModel(BakedModel baseModel, boolean specialItemModel) {
        super(baseModel);
        this.specialItemModel = specialItemModel;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        IModelData dataLeft = (IModelData)extraData.getData(FramedDoubleBlockEntity.DATA_LEFT);
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((BakedModel)models.m_14418_()).getQuads((BlockState)this.dummyStates.m_14418_(), side, rand, (IModelData)(dataLeft != null ? dataLeft : EmptyModelData.INSTANCE)));
        IModelData dataRight = (IModelData)extraData.getData(FramedDoubleBlockEntity.DATA_RIGHT);
        quads.addAll(FramedDoubleBlockModel.invertTintIndizes(((BakedModel)models.m_14419_()).getQuads((BlockState)this.dummyStates.m_14419_(), side, rand, (IModelData)(dataRight != null ? dataRight : EmptyModelData.INSTANCE))));
        return quads;
    }

    @Override
    @Deprecated
    public List<BakedQuad> m_6840_(BlockState state, Direction side, Random rand) {
        if (this.specialItemModel) {
            Tuple<BakedModel, BakedModel> models = this.getModels();
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(((BakedModel)models.m_14418_()).m_6840_((BlockState)this.dummyStates.m_14418_(), side, rand));
            quads.addAll(((BakedModel)models.m_14419_()).m_6840_((BlockState)this.dummyStates.m_14419_(), side, rand));
            return quads;
        }
        return super.m_6840_(state, side, rand);
    }

    public TextureAtlasSprite getParticleIcon(@Nonnull IModelData data) {
        Tuple<BakedModel, BakedModel> models = this.getModels();
        IModelData innerData = (IModelData)data.getData(FramedDoubleBlockEntity.DATA_LEFT);
        if (innerData != null && !((BlockState)innerData.getData(FramedBlockData.CAMO)).m_60795_()) {
            return ((BakedModel)models.m_14418_()).getParticleIcon(innerData);
        }
        innerData = (IModelData)data.getData(FramedDoubleBlockEntity.DATA_RIGHT);
        if (innerData != null && !((BlockState)innerData.getData(FramedBlockData.CAMO)).m_60795_()) {
            return ((BakedModel)models.m_14419_()).getParticleIcon(innerData);
        }
        return this.baseModel.m_6160_();
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof FramedDoubleBlockEntity) {
            FramedDoubleBlockEntity be = (FramedDoubleBlockEntity)blockEntity;
            return be.getModelData();
        }
        return tileData;
    }

    protected abstract Tuple<BlockState, BlockState> getDummyStates();

    protected Tuple<BakedModel, BakedModel> getModels() {
        if (this.models == null) {
            if (this.dummyStates == null) {
                this.dummyStates = this.getDummyStates();
            }
            BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
            this.models = new Tuple((Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14418_()), (Object)dispatcher.m_110910_((BlockState)this.dummyStates.m_14419_()));
        }
        return this.models;
    }

    protected TextureAtlasSprite getSpriteOrDefault(IModelData data, ModelProperty<IModelData> key, BakedModel model) {
        IModelData innerData = (IModelData)data.getData(key);
        if (innerData != null && !((BlockState)innerData.getData(FramedBlockData.CAMO)).m_60795_()) {
            return model.getParticleIcon(innerData);
        }
        return this.baseModel.m_6160_();
    }

    private static List<BakedQuad> invertTintIndizes(List<BakedQuad> quads) {
        return quads.stream().map(ModelUtils::invertTintIndex).collect(Collectors.toList());
    }
}

